@extends('app')
@section('title')
<title>My Reviews</title>
@endsection

@push('css')

<style type="text/css">
    .myrecentorder tr td,th{
        padding:5px !important;
    }
    .userdashboard{
        min-height: 500px;
    }
    @media (max-width: 768px) {
       .userdashboard{
            min-height: 300px;
        } 
    }
</style>

@endpush
@section('content')

<div class="userdashboard">
    <div class="container">
    <div class="row" style="margin:0;">
        <div class="col-lg-3 usersidebardiv">
            @include('customer.includes.sidebar')
            
        </div>
        <div class="col-lg-9 usermainbody">
            <div class="usercontent">
                <div class="myrecentorder" style="min-height: 300px;">
                    <p style="font-weight: bold;border-bottom: 1px solid #eaeded;padding: 5px 0;">My Reviews</p>
                    <div  class="table-responsive">
                    <table class="table table-bordered">

                    <tr style="background: #f3f3f3;">
                        <th style="min-width: 50px;">SL</th>
                        <th style="min-width: 100px;">Image</th>
                        <th style="min-width: 200px;">Product</th>
                        <th style="min-width: 50px;">Star</th>
                        <th style="min-width: 120px;">date</th>
                    </tr>

                    @foreach($reviews as $i=>$review)

                     <tr>
                        <td rowspan="2" style="text-align: center;">{{$reviews->currentpage()==1?$i+1:$i+($reviews->perpage()*($reviews->currentpage() - 1))+1}}</td>
                        <td><img width="80" class="rounded p-0 m-0" src="{{asset($review->image)}}" alt="{{$review->product->name}}"></td>
                          <td>{{ Str::limit($review->product->name,35,'..') }}</td>
                          <td>
                              {{ $review->review }}
                          </td>
                          <td>
                              {{ $review->created_at->format('d-m-Y') }}
                          </td>
                    </tr>
                    @endforeach
                    </table>
                    </div>
                    {!! $reviews->links() !!}
                </div>
                
            </div>
        </div>
    </div>
    </div>
</div>
@endsection
@push('js')
@endpush