@extends('app')
@section('title')
<title>Profile Edit</title>
@endsection

@push('css')
<style type="text/css">
     .userdashboard{
        min-height: 500px;
    }
    @media (max-width: 768px) {
       .userdashboard{
            min-height: 300px;
        } 
    }
</style>
@endpush
@section('content')

<div class="userdashboard">
    <div class="container">
    <div class="row" style="margin:0;">
        <div class="col-lg-3 usersidebardiv">
            @include('customer.includes.sidebar')
            
        </div>
        <div class="col-lg-9 usermainbody">
            <div class="usercontent">
                <div class="myrecentorder">
                    
                    <p style="font-weight: bold;border-bottom: 1px solid #eaeded;padding: 5px 0;">My Profile Update</p>
                    <div>
                        <form method="POST" action="{{ route('customer.profileUpdate') }}" enctype="multipart/form-data">
                            @csrf
                                  <div class="form-group row mb-3">
                                    <label for="inputPassword" class="col-sm-3 col-form-label">Name*</label>
                                    <div class="col-sm-9">
                                      @if ($errors->has('name'))
                                        <p style="color: red;margin: 0;">{{ $errors->first('name') }}</p>
                                      @endif
                                      <input type="text" class="form-control" name="name" value="{{Auth::user()->name}}"  placeholder="Your Name" required="">
                                    </div>
                                  </div>
                                   <div class="form-group row">
                                    <label for="inputPassword" class="col-sm-3 col-form-label">Company Name </label>
                                    <div class="col-sm-9">
                                        @if ($errors->has('company'))
                                        <p style="color: red;margin: 0;">{{ $errors->first('company') }}</p>
                                      @endif
                                      <div class="input-group mb-3">
                                           <input type="text" class="form-control" name="company" value="{{Auth::user()->company_name?:old('company')}}" placeholder="Company Name">
                                        </div>
                                    </div>
                                  </div>
                                   <div class="form-group row">
                                    <label for="inputPassword" class="col-sm-3 col-form-label">Email Name*</label>
                                    <div class="col-sm-9">
                                        @if ($errors->has('email'))
                                        <p style="color: red;margin: 0;">{{ $errors->first('email') }}</p>
                                      @endif
                                      <div class="input-group mb-3">
                                           <input type="email" class="form-control" name="email" value="{{Auth::user()->email}}" placeholder="Email Address" required="">
                                        </div>
                                    </div>
                                  </div>
                                   <div class="form-group row">
                                    <label for="inputPassword" class="col-sm-3 col-form-label">Mobile Number*</label>
                                    <div class="col-sm-9">
                                        @if ($errors->has('phone'))
                                        <p style="color: red;margin: 0;">{{ $errors->first('phone') }}</p>
                                        @endif
                                        <div class="input-group mb-3">
                                          <input type="text" name="phone" class="form-control" placeholder="Phone Number" value="{{Auth::user()->phone}}" >
                                        </div>
                                    </div>
                                  </div>
                                  
                     
                                   
                                    
                                  <div class="form-group row mb-3">
                                    <label for="inputPassword" class="col-sm-3 col-form-label">Address*</label>
                                    <div class="col-sm-9">
                                        @if ($errors->has('address'))
                                        <p style="color: red;margin: 0;">{{ $errors->first('address') }}</p>
                                      @endif
                                      <input type="text" class="form-control" name="address" value="{{Auth::user()->address}}"  placeholder="Exp: House Road..">
                                    </div>
                                  </div>
                                  
                                  <div class="form-group row">
                                    <label for="inputPassword" class="col-sm-3 col-form-label"></label>
                                    <div class="col-sm-9">
                                     <button type="submit" class="btn btn-primary">Update Profile</button>
                                    </div>
                                  </div>
                                </form> 
                    </div>
                </div>
            </div>
        </div>
    </div>
    </div>
</div>
@endsection
@push('js')
@endpush