
@php
    $pdata=getProductInfo($single_product);
    
@endphp

  <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
    <div class="modal-content ">
      <div class="modal-header bg-warning">
        <h5 class="modal-title" id="modalTitleId">
          Choose Size and Color
        </h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body product_modal">
        <div class="row">
            
            <div class="col-lg-5 col-md-6 col-sm-8 col-12">
            <div id="product" class="carousel slide" data-bs-ride="false" >
                <div class="carousel-inner" role="listbox">
                    <div class="carousel-item active">
                        <div class="easyzoom easyzoom--overlay w-100">
                            <a href="{{ getImage('images/product/large', $single_product->main_image)}}" data-fancybox="gallery" class="fancybox">
                                <img
                                src="{{ getImage('images/product/large', $single_product->main_image)}}"
                                class="w-100"
                                alt="First slide"
                            />
                            </a>
                        </div>
                        
                    </div>
                    
                    @foreach($single_product->images as $key=>$im)
                    <div class="carousel-item {{$im->color}}">
                        <div class="easyzoom easyzoom--overlay w-100">
                            <a href="{{ getImage('images/product/large', $im->image)}}"  data-fancybox="gallery" class="fancybox">
                                <img
                                src="{{ getImage('images/product/large', $im->image)}}"
                                class="w-100"
                                alt="First slide"
                            />
                            </a>
                        </div>
                    </div>
                    @endforeach
                </div>
                <button class="carousel-control-prev" type="button" data-bs-target="#product" data-bs-slide="prev">
                    <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                    <span class="visually-hidden">Previous</span>
                </button>
                <button class="carousel-control-next" type="button" data-bs-target="#product" data-bs-slide="next">
                    <span class="carousel-control-next-icon" aria-hidden="true"></span>
                    <span class="visually-hidden">Next</span>
                </button>
                
            </div>
            <div class="carousel-indicators nav_images position-relative" id="nav_images">
                
                
                <img src="{{ getImage('images/product/large', $single_product->main_image)}}" alt="" width="100" data-bs-target="#product" data-bs-slide-to="0" class="active" aria-current="true">
                @foreach($single_product->images as $key=>$im)
                
                <img src="{{ getImage('images/product/large', $im->image)}}" alt="" width="100" data-bs-target="#product" data-bs-slide-to="{{$key+1}}">
                @endforeach
            </div>
            
        </div>
            
            <div class="col-lg-6 col-md-6 col-sm-8 col-12">
            
                <h2 class="title light">{!! $single_product->name !!} </h2>
                <h4 class="pop bold"> {!! $pdata['price'] !!} </h4>
                
                
                
                <div class="size_chart mt-3 d-none">
                    <img src="{{ asset('assets/image/size.png')}}" alt="" class="img-fluid">
                </div>
                
                
                <form method="POST" action="{{ route('carts.store')}}" id="cart_form_order">
                @if($single_product->is_variant)
                @foreach($options as $key=>$option)
                
                @php
                    $vs=explode(",",$values[$key]);
                    $op=str_replace('"','',$option);
                @endphp
                
                <h4 class="pop medium">{{$op}}:</h4>
                
               
                    
                <div class="sizes d-flex flex-wrap align-items-center gap-4">
                        @foreach($vs as $i=>$v)
                        @php
                            $value=str_replace('"','',$v);
                        @endphp
                        <div class="burmanRadio">
                            <input type="radio" class="burmanRadio__input {{$op}}" id="size-{{$value}}" {{$i==0?'checked':''}} name="variant_{{$key+1}}" value="{{ $value }}">
                            <label for="size-{{$value}}" class="burmanRadio__label"> {{ $value }} </label>
                        </div>
                        @endforeach
                    </div>
                    @endforeach
                    @endif 
                
                    <div class="d-flex align-items-center mt-4 col-lg-12">
                        @csrf
                        <input type="hidden" name="product_id" value="{{ $single_product->id}}">
                
                        <div class="quantity_box">
                            <button type="button" class="minus btn">-</button>
                            <input type="text" class="quantity_value placeholder_black form-control" name="quantity" value="1"  min="1" max="12" >
                            <button type="button" class="plus btn">+</button>
                        </div>
                        <button type="submit" class="btn btn-dark ms-3 semi text-cap">অর্ডার করুন</button>
                    </div>
                    </form>
                    
                    
            </div>
        
        </div>
      </div>
      
      <style>
        .quantity_box{
            display: inline-flex;
            vertical-align: top;
            white-space: nowrap;
            font-size: 0;
        }
        div.quantity_box button[type="button"] {
            padding: 0 5px;
            min-width: 25px;
            min-height: unset;
            height: 42px;
            border: 2px solid rgb(211, 211, 211);
            background: white;
            box-shadow: none;
            color: black;
            border-radius: 0;
        }
        div.quantity_box button[type="button"]:hover {
            color: #fff;
            background-color: orange;
            border-color: orange;
        }
        div.quantity_box input[type="text"] {
            width: 40px;
            color: black;
            border-radius: 0;
            border: 2px solid rgb(211, 211, 211);
            border-right: none;
            border-left: none;
        }
        div.quantity_box button[type="button"].minus {
            border-radius: 10px 0 0 10px;
        }
        div.quantity_box button[type="button"].plus {
            border-radius: 0 10px 10px 0;
        }
        
       .burmanRadio {
            margin-bottom: 10px;
          }
          .burmanRadio__input {
            display: none;
          }
          .burmanRadio__input:checked ~ .burmanRadio__label::after {
            opacity: 1;
            transform: scale(1);
          }
          .burmanRadio__label {
            cursor: pointer;
            line-height: 30px;
            position: relative;
            margin-left: 35px;
          }
          .burmanRadio__label::before, .burmanRadio__label::after {
            border-radius: 50%;
            position: absolute;
            top: 5px;
            left: -30px;
            transition: all 0.3s ease-out;
            z-index: 2;
          }
          .burmanRadio__label::before {
            content: "";
            border: 1.5px solid #9d9d9d;
            width: 20px;
            height: 20px;
          }
          .burmanRadio__label::after {
            font-family: "Font Awesome 5 Free"; font-weight: 900; content: "\f00c";
            background: #ffc107;
            border: 1.5px solid #ffc107;
            color: #FFF;
            display: flex;
            justify-content: center;
            align-items: center;
            opacity: 0;
            width: 20px;
            height: 20px;
            transform: scale(0);
          }
          .burmanRadio__label:hover::before {
            border-color: #7BC4CA;
          }
         
                          
    </style>

    </div>
</div>

<script>
    $(document).on('click','.color', function(){
        
        let color_name=$(document).find('.color:checked').val();
        
        if(color_name){
            if($(document).find('.carousel-item').hasClass(color_name)){
                $(document).find('.carousel-item').removeClass('active');
                $(document).find('.'+color_name).addClass('active');
            }else{
                
            }
        }
        
    });
</script>
